/**
 * Asta - JavaScript Utilities
 *
 * Core framework utilities for maintaining grid alignment, theme management,
 * modals, and navigation. This is the main library for the Asta Design System.
 *
 * @author Antonio Roldao
 * @license MIT
 */
const CLASSES={OPEN:"open",VISIBLE:"visible",DEBUG:"debug",OFF_GRID:"off-grid"};function gridCellDimensions(){const e=document.createElement("div");e.style.position="fixed",e.style.height="var(--line-height)",e.style.width="1ch",document.body.appendChild(e);const t=e.getBoundingClientRect();return document.body.removeChild(e),{width:t.width,height:t.height}}function adjustMediaPadding(){const e=gridCellDimensions();function t(t){const n=t.getBoundingClientRect(),i=Math.round(n.width/2/e.height)*e.height;t.style.setProperty("height",`${i}px`)}function n(n){var i,o;switch(n.tagName){case"IMG":i=n.naturalWidth,o=n.naturalHeight;break;case"VIDEO":i=n.videoWidth,o=n.videoHeight}i>0&&o>0?function(t,n){const i=t.getBoundingClientRect().width/n,o=e.height-i%e.height;t.style.setProperty("padding-bottom",`${o}px`)}(n,i/o):t(n)}const i=document.querySelectorAll("img, video");for(media of i)switch(media.tagName){case"IMG":media.complete?n(media):(media.addEventListener("load",()=>n(media)),media.addEventListener("error",function(){t(media)}));break;case"VIDEO":switch(media.readyState){case HTMLMediaElement.HAVE_CURRENT_DATA:case HTMLMediaElement.HAVE_FUTURE_DATA:case HTMLMediaElement.HAVE_ENOUGH_DATA:n(media);break;default:media.addEventListener("loadeddata",()=>n(media)),media.addEventListener("error",function(){t(media)})}}}function checkOffsets(){const e=new Set(["THEAD","TBODY","TFOOT","TR","TD","TH"]),t=gridCellDimensions(),n=document.querySelectorAll("body :not(.debug-grid, .debug-toggle)");for(const i of n){if(e.has(i.tagName))continue;const n=i.getBoundingClientRect();if(0===n.width&&0===n.height)continue;const o=n.top+window.scrollY;o%(t.height/2)>0?(i.classList.add(CLASSES.OFF_GRID),console.error("Incorrect vertical offset for",i,"with remainder",o%t.height,"when expecting divisible by",t.height/2)):i.classList.remove(CLASSES.OFF_GRID)}}const THEME_STORAGE_KEY="asta-theme";function getTheme(){return localStorage.getItem("asta-theme")}function setTheme(e){const t=document.documentElement;null===e?(localStorage.removeItem("asta-theme"),t.removeAttribute("data-theme")):(localStorage.setItem("asta-theme",e),t.setAttribute("data-theme",e))}function toggleTheme(){const e=getTheme();document.documentElement;let t;t=e||(window.matchMedia("(prefers-color-scheme: dark)").matches?"dark":"light");const n="dark"===t?"light":"dark";return setTheme(n),n}function initThemeToggle(){const e=getTheme();e&&document.documentElement.setAttribute("data-theme",e);const t=document.querySelector(".theme-toggle");if(t){const e=getTheme()||(window.matchMedia("(prefers-color-scheme: dark)").matches?"dark":"light");t.checked="dark"===e,t.addEventListener("change",()=>{const e=toggleTheme();t.checked="dark"===e})}}function openModal(e){const t=document.getElementById(e);t&&(t.classList.add(CLASSES.OPEN),document.body.style.overflow="hidden")}function closeModal(e){const t=document.getElementById(e);t&&(t.classList.remove(CLASSES.OPEN),document.body.style.overflow="")}function initNavMenus(){document.querySelectorAll(".nav-menu").forEach(e=>{const t=e.querySelector(".nav-toggle");if(t){t.addEventListener("click",()=>{e.classList.toggle(CLASSES.OPEN)});e.querySelectorAll(".nav-list a").forEach(t=>{t.addEventListener("click",()=>{e.classList.remove(CLASSES.OPEN)})})}})}function initAsta(){initThemeToggle(),adjustMediaPadding(),window.addEventListener("load",adjustMediaPadding),window.addEventListener("resize",adjustMediaPadding),initNavMenus()}document.addEventListener("keydown",function(e){if("Escape"===e.key){document.querySelectorAll(`.modal.${CLASSES.OPEN}`).forEach(e=>{e.classList.remove(CLASSES.OPEN),document.body.style.overflow=""})}}),"loading"===document.readyState?document.addEventListener("DOMContentLoaded",initAsta):initAsta(),"undefined"!=typeof module&&module.exports&&(module.exports={gridCellDimensions:gridCellDimensions,adjustMediaPadding:adjustMediaPadding,checkOffsets:checkOffsets,getTheme:getTheme,setTheme:setTheme,toggleTheme:toggleTheme,openModal:openModal,closeModal:closeModal,initNavMenus:initNavMenus,initAsta:initAsta});